<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

$post_title  = explode( '|', str_replace( '&#8211;', '|', get_the_title( $post_id ) ) );
$post_images = get_the_post_thumbnail_url( $post_id );
$default_img = get_stylesheet_directory_uri() . '/assets/images/bg-prediksi.jpg';

?>

<div class="card card-post bg-transparent shadow border-0 mb-3 mb-lg-4">
    <div class="row no-gutters">
        <div class="col-12 col-lg-auto">
            <div class="post-thumbnail bg-color-1 h-100">
                <img class="img-fluid rounded-start h-100" src="<?php echo ( ($post_images == null) ? $default_img : $post_images ); ?>">
            </div>
        </div>
        <div class="col-12 col-lg">
            <div class="post-content h-100">
                <div class="card bg-transparent border-0 h-100">
                    <div class="card-header px-3 py-3 px-lg-2 bg-gradient-1">
                        <a class="text-decoration-none" href="<?php echo get_the_permalink( $post_id ); ?>">
                            <h5 class="card-title text-white text-uppercase mb-0">
                                <small class="font-weight-bold"><?php echo get_the_title( $post_id ); ?></small>
                            </h5>
                        </a>
                    </div>
                    <div class="card-body bg-white px-3 py-3 px-lg-2 py-lg-2">
                        <div class="text-justify"><small><?php echo get_the_excerpt( $post_id ) . ' [...]'; ?></small></div>
                    </div>
                    <div class="card-footer bg-dark border-0 text-center text-lg-right px-3 py-3 px-lg-2 py-lg-2">
                        <div class="row no-gutters align-items-center justify-content-between">
                            <div class="col-12 col-lg-auto">
                                <?php foreach ( get_the_category() as $cat ) : ?>
                                    <span class="badge badge-secondary font-weight-normal p-2 mb-3 mb-lg-0">
                                        <i class="fas fa-folder-open"></i>&ensp;<?php echo $cat->name; ?>
                                    </span>
                                <?php endforeach; ?>
                            </div>
                            <div class="col-12 col-lg-auto">
                                <a href="<?php echo get_the_permalink(); ?>" class="btn btn-sm btn-warning text-uppercase">
                                    <small class="font-weight-bold">Lihat prediksi</small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
