<?php
/**
 * @package web-result
 * @since 1.0.0
 */

function get_paito( $pasaran = 'hongkong' ) {
    switch ( $pasaran ) {
        case 'toto-macau-5d-1' :
            return scrape_paito_toto_macau_5d( 'day' );
        break;
        case 'toto-macau-5d-2' :
            return scrape_paito_toto_macau_5d( 'eve' );
        break;
        case 'toto-macau' :
            $link = 'https://47.252.8.229/site/paito/paitotable.php?status=TOTOMACAU';

            return scrape_link_paito( $link );
        break;

        default :
            $link = 'https://sayapcerutu.com/';
            $name = 'ilhamtest678';
            $pass = 'f84add4dd5c68e332dc3244e2552be1e';
            $file = get_stylesheet_directory() . '/functions/page-' . $pasaran . '.php';

            if ( file_exists( $file ) ) {
                require_once $file;

                return scrape_paito( $code, $link, $name, $pass );
            }
        break;
    }
}

function scrape_link_paito( $link = '', $table_id = 'drawing-table' ) {
    ini_set("user_agent", "Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0");
    
    $curl = curl_init();
    curl_setopt_array( $curl, [
        CURLOPT_URL            => $link,
        CURLOPT_COOKIE         => 'PHPSESSID=gv0cpgujm5t809hi64dg1u7pf2;',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
    ] );
    session_write_close();
    $text = curl_exec( $curl );
    curl_close( $curl );
    $html = str_get_html( $text );
    $data = $html->find( 'table[id="' . $table_id . '"]', 0 );

    foreach ( $data->find( 'tr', 0 )->find( 'td' ) as $top ) {
        $top->class = 'top';
    }

    foreach ( $data->find( 'td' ) as $td ) {
        if ( $td->class == 'jppro' || $td->class == 'pto' || $td->class == 'reside' || $td->class == 'text-center ke' ) {
            $td->class = 'asu';
        } elseif ( $td->class == 'jpro' || $td->class == 'ptox' || $td->class == 'residex' || $td->class == 'text-center jml' ) {
            $td->class = 'asux';
        }
    }
    
    return [ 'is_top' => false, 'data' => $data->outertext ];
}

function web_idn_login( $link, $name, $pass ) {
    $file = EXCPATH . '/cookies/' . md5( $pass ) . '.txt';
    $curl = curl_init();

    if ( !file_exists( $file ) ) {
        $fh = fopen( $file, "w+" );
        fwrite( $fh, "" );
        fclose( $fh );
    }

    curl_setopt_array( $curl, [
        CURLOPT_URL            => $link . 'history_detil.php',
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
        CURLOPT_COOKIEJAR      => $file,
        CURLOPT_COOKIEFILE     => $file,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => "entered_login='$name'&vb_login_md5password='$pass'&vb_login_md5password_utf='$pass'",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_AUTOREFERER    => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_VERBOSE        => true,
    ] );
    session_write_close();
    curl_exec( $curl );
    curl_close( $curl );
}

function web_idn_history( $link, $name, $pass, $code, $start, $end ) {
    web_idn_login( $link, $name, $pass );

    $file = EXCPATH . '/cookies/' . md5( $pass ) . '.txt';
    $curl = curl_init();

    curl_setopt_array( $curl, [
        CURLOPT_URL            => $link . 'history_detil.php',
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
        CURLOPT_COOKIEJAR      => $file,
        CURLOPT_COOKIEFILE     => $file,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => "pasar='$code'&start='$start'&end='$end'",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_AUTOREFERER    => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_VERBOSE        => true,
    ] );
    session_write_close();
    $data = curl_exec( $curl );
    curl_close( $curl );

    return format_history( $data );
}

function scrape_paito( $code, $link, $name, $pass ) {
    $numb = 0;
    $list = [];
    
    $p1 = 1; $p2 = 10;

    for ( $n = 1; $n <= 12; $n++ ) {
        foreach ( (array)web_idn_history( $link, $name, $pass, $code, $p1, $p2 ) as $data ) {
            $list[$numb] = $data;

            $numb++;
        }

        $p1 += 10; $p2 += 10;
    }

    krsort( $list );
    
    return [ 'is_top' => false, 'data' => format_paito( $list ) ];
}

function scrape_paito_toto_macau_5d( $type = 'day' ) {
    $list = get_paito_macau_5d( $type );

    krsort($list);

    return [ 'is_top' => false, 'data' => format_paito_table( $list ) ];
}

function get_paito_macau_5d( $type = 'day' ) {
    ini_set("user_agent", "Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0");

    $numb = 1;
    $list = [ 'day' => [], 'eve' => [] ];
    $curl = curl_init();
    curl_setopt_array( $curl, [
        CURLOPT_URL            => 'https://livedrawpedia.com/data-totomacau5d-lengkap-' . date('Y') . '.php',
        CURLOPT_COOKIE         => 'PHPSESSID=gv0cpgujm5t809hi64dg1u7pf2;',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
    ] );
    session_write_close();
    $text = curl_exec( $curl );
    curl_close( $curl );
    $html = str_get_html( $text );

    foreach ( $html->find('table[class="tab"]') as $table ) {
        foreach ( $table->find('td[class="tdmacau"]') as $td ) {
            if ( $numb % 2 == false ) {
                $list['eve'][] = $td->plaintext;
            } else {
                $list['day'][] = $td->plaintext;
            }

            $numb++;
        }
    }

    return $list[$type];
}

function format_history( $text ) {
    $numb = 0;
    $list = [];
    $html = str_get_html( $text );
    $data = $html->find( 'table', 0 )->find( 'tbody', 0 );

    foreach ( $data->find( 'tr' ) as $tr ) {
        $date = trim( substr( $tr->find( 'td', 0 )->plaintext, 0, 10 ) );

        $list[$numb] = [
            'tanggal' => date_i18n( 'Y-m-d', strtotime( $date ) ),
            'hari'    => date( 'l', strtotime( $date ) ),
            'angka'   => trim( $tr->find( 'td', 3 )->plaintext ),
            'periode' => trim( str_replace( '-', '', $tr->find( 'td', 2 )->plaintext ) )
        ];

        $numb++;
    }

    return $list;
}

function format_paito( $data = [] ) {
    $numb  = 1;
    $html  = '<table id="drawing-table" border="1" width="100%">';
    $html .= '<tbody>';
    $html .= '<tr><td colspan="4" class="top"><b>Senin</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Selasa</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Rabu</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Kamis</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Jumat</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Sabtu</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Minggu</b></td></tr>';
    $html .= '<tr>';
    $html .= '<tr>';
    
    foreach ( (array)$data as $item ) {
        $digits = str_split( $item['angka'] );

        if ( $numb == 1 ) {
            if ( $item['hari'] == 'Tuesday' ) {
                $tdnumb = 1; $numb += 1;
            } elseif ( $item['hari'] == 'Wednesday' ) {
                $tdnumb = 2; $numb += 2;
            } elseif ( $item['hari'] == 'Thursday' ) {
                $tdnumb = 3; $numb += 3;
            } elseif ( $item['hari'] == 'Friday' ) {
                $tdnumb = 4; $numb += 4;
            } elseif ( $item['hari'] == 'Saturday' ) {
                $tdnumb = 5; $numb += 5;
            } elseif ( $item['hari'] == 'Monday' ) {
                $tdnumb = 6; $numb += 6;
            } else {
                $tdnumb = 0;
            }

            for ( $t = 1; $t <= $tdnumb; $t++ ) {
                $html .= '<td class="asu"></td>';
                $html .= '<td class="asu"></td>';
                $html .= '<td class="asu"></td>';
                $html .= '<td class="asu"></td>';
                $html .= '<td class="asux"></td>';
            }
        }

        foreach ( (array)$digits as $digit ) {
            $html .= '<td class="asu">' . $digit . '</td>';
        }

        $html .= '<td class="asux"></td>';

        if ( $numb % 7 == false ) { $html .= '</tr><tr>'; }

        $numb++;
    }

    $html .= '</tr>';
    $html .= '</tbody>';
    $html .= '</table>';

    return $html;
}

function format_paito_table( $list = [] ) {
    if ( $list != null ) {
        $addon = 0;
        $numb  = 1;
        $html  = '<table id="drawing-table" border="1" width="100%">';
        $html .= '<tbody>';
        $html .= '<tr><td colspan="4" class="top"><b>Senin</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Selasa</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Rabu</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Kamis</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Jumat</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Sabtu</b></td> <td class="asux top"></td> <td colspan="4" class="top"><b>Minggu</b></td></tr>';
        $html .= '<tr>';

        switch ( date_i18n('l', strtotime( date('Y-01-01') )) ) {
            case 'Senin' :
                $addon = 0;
                $numb += $addon;
            break;
            case 'Selasa' :
                $addon = 1;
                $numb += $addon;
            break;
            case 'Rabu' :
                $addon = 2;
                $numb += $addon;
            break;
            case 'Kamis' :
                $addon = 3;
                $numb += $addon;
            break;
            case 'Jumat' :
                $addon = 4;
                $numb += $addon;
            break;
            case 'Sabtu' :
                $addon = 5;
                $numb += $addon;
            break;
            case 'Minggu' :
                $addon = 6;
                $numb += $addon;
            break;
        }

        for ($i = 1; $i <= $addon; $i++) {
            for ($n = 1; $n <= 4; $n++) {
                $html .= '<td class="asu"></td>';
            }
            $html .= '<td class="asux"></td>';
        }
        
        foreach ( $list as $data ) {
            if ( is_numeric( $data ) ) {
                $order = (array)str_split( substr( $data, -4 ) );

                foreach ( $order as $digit ) {
                    $html .= '<td class="asu">' . $digit . '</td>';
                }
                $html .= '<td class="asux"></td>';
                $html .= ($numb % 7 == false) ? '</tr><tr>' : '';

                $numb++;
            }
        }
        
        $html .= '</tr>';
        $html .= '</tbody>';
        $html .= '</table>';

        return $html;
    }
}
