<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

global $paged;

if (get_query_var( 'paged' )) {
    $paged = get_query_var( 'paged' );
} elseif (get_query_var( 'page' )) {
    $paged = get_query_var( 'page' );
} else {
    $paged = '1';
}

get_header();

?>

<section>
    <div class="container bg-color-2 shadow px-3 py-3">
        <div class="row no-gutters">
            <div class="col-12 col-lg-8 pr-lg-3">
                <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) :
                            the_post();

                            set_query_var( 'post_id', get_the_ID() );
                            get_template_part( 'components/part-card', 'post' );
                        endwhile;
                    endif;
                ?>

                <hr class="border-light">

                <div class="row no-gutters">
                    <div class="col-6 text-left">
                        <?php next_posts_link( '← Sebelumnya' ); ?>
                    </div>
                    <div class="col-6 text-right">
                        <?php previous_posts_link( 'Selanjutnya →' ); ?>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0"><?php get_template_part('components/part', 'sidebar'); ?></div>
        </div>
    </div>
</section>

<?php

get_footer();
