<?php
/**
 * Template Name: Beranda
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$prediksi = $exito->get_pasaran_prediksi();

get_header();

?>

<section>
    <div class="container bg-color-2 shadow px-3 py-3">
        <div class="row no-gutters">
            <div class="col-12 col-lg-8 pr-lg-3">
                <?php
                    if ( $prediksi->have_posts() ) :
                        while ( $prediksi->have_posts() ) :
                            $prediksi->the_post();

                            set_query_var( 'post_id', $prediksi->ID );
                            get_template_part( 'components/part-card', 'post' );
                        endwhile;
                    endif;
                ?>

                <hr class="border-light">

                <div class="row no-gutters">
                    <div class="col-6 text-left">
                        <?php next_posts_link( '← Sebelumnya', $prediksi->max_num_pages ); ?>
                    </div>
                    <div class="col-6 text-right">
                        <?php previous_posts_link( 'Selanjutnya →' ); ?>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0"><?php get_template_part('components/part', 'sidebar'); ?></div>
        </div>
    </div>
</section>

<?php if ( have_posts() ) : while ( have_posts() ) : ?>
    <section>
        <div class="container px-0 py-0">
            <div class="content content-home bg-color-3 text-white text-justify px-3 py-3 px-lg-4 py-lg-4">
                <?php the_post(); the_content(); ?>
            </div>
        </div>
    </section>
<?php endwhile; endif; ?>

<?php

get_footer();
