<?php
/**
 * Template Name: Data Result
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$history = $exito->get_history( get_post_meta( get_the_ID(), 'link-scrape', true ) );

get_header();

?>

<section>
    <div class="container bg-color-2 shadow px-3 py-3">
        <div class="row no-gutters">
            <div class="col-12 col-lg-8">
                <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <div class="card card-blog bg-color-3 shadow border-0 mr-lg-3">
                        <div class="card-header p-3 bg-gradient-1 border-0">
                            <h5 class="card-title text-white text-center text-uppercase mb-0">
                                <span class="font-weight-bold"><?php echo get_the_title(); ?></span>
                            </h5>
                        </div>
                        <div class="card-body p-3">
                            <div class="result-wrapper mb-3">
                                <table class="table table-result table-borderless table-striped text-dark text-center bg-light mb-0">
                                    <thead class="bg-gradient-2 text-dark">
                                        <tr>
                                            <th>Tanggal</th>
                                            <th class="d-none d-lg-table-cell">Hari</th>
                                            <th class="d-none d-lg-table-cell">Periode</th>
                                            <th>Result</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ( $history as $data ) : ?>
                                            <tr>
                                                <td><?php echo $data['tanggal']; ?></td>
                                                <td class="d-none d-lg-table-cell"><?php echo $data['hari']; ?></td>
                                                <td class="d-none d-lg-table-cell">#<?php echo $data['periode']; ?></td>
                                                <td>
                                                    <div class="result-number">
                                                        <?php
                                                            $numbers = str_split( $data['result'] );
                                                            foreach ( $numbers as $digit ) {
                                                                echo '<div class="d-inline-block digit"><b>' . $digit . '</b></div>';
                                                            }
                                                        ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="content content-home text-justify text-white">
                                <?php the_content(); ?>
                                <hr class="my-3 border-light border-dashed">
                                <div class="tags-wrapper">
                                    <p class="text-white text-left mb-1">Tags :</p>
                                    <?php if ( !empty( get_the_tags() ) ) : foreach ( get_the_tags() as $tag ) : ?>
                                        <a href="<?php echo get_tag_link( $tag->term_id ); ?>" class="badge badge-dark text-white font-weight-normal px-2 py-2 mb-0 mt-1"><?php echo $tag->name; ?></a>
                                    <?php endforeach; endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; endif; ?>
            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0"><?php get_template_part('components/part', 'sidebar'); ?></div>
        </div>
    </div>
</section>

<?php

get_footer();
